/*****************************************************************************
*
* Copyright 2018-2019 NXP
* All Rights Reserved
*
*****************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************/
#ifndef APUFAST9GRAPHNAMES_H
#define APUFAST9GRAPHNAMES_H

// PI stands for Process Identifier
// GN stands for Graph Name
#include "common_stringify_macros.h"

#define FAST9_PI			APU_FAST9
#define FAST9_GN			XSTR(FAST9_PI)

#define FAST9_COLOR_PI		APU_FAST9_COLOR
#define FAST9_COLOR_GN		XSTR(FAST9_COLOR_PI)

#define FAST9_GRAPH_IN0		"INPUT_0"
#define FAST9_GRAPH_IN1		"INPUT_1"
#define FAST9_GRAPH_IN2		"INPUT_2"
#define FAST9_GRAPH_OUT		"OUTPUT_0"


#define FAST9_GRAPH_THR		"THRESHOLD"
#define FAST9_GRAPH_MARK	"MARK_COLOR_CHANNEL"

#endif /* APUFAST9GRAPHNAMES_H */
